/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.servlet.util;

import com.ibm.hwmca.ui.bonsai.BonsaiUIStyle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TaskUrl
implements Cloneable,
Serializable {
    public static final String TASK_VAR_NAME = "task";
    public static final String TYPE_VAR_NAME = "type";
    public static final String TARGET_VAR_NAME = "targets";
    public static final String PARENT_VAR_NAME = "parent";
    private String taskId;
    private int taskType;
    private List targetList = new ArrayList();
    private String parent;

    public TaskUrl(String target) {
        this(null, 3, target, null);
    }

    public TaskUrl(String target, String parent) {
        this(null, 3, target, parent);
    }

    public TaskUrl(String taskId, int taskType) {
        this(taskId, taskType, null, null);
    }

    public TaskUrl(String taskId, int taskType, String target) {
        this(taskId, taskType, target, null);
    }

    public TaskUrl(String taskId, int taskType, String target, String parent) {
        this.taskId = taskId;
        this.taskType = taskType;
        if (target != null) {
            this.targetList.add(target);
        }
        this.parent = parent;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getTaskType() {
        return this.taskType;
    }

    public List getTargets() {
        return this.targetList;
    }

    public void addTarget(String target) {
        this.targetList.add(target);
    }

    public void addTargets(List targets) {
        this.targetList.addAll(targets);
    }

    public void setTarget(String target) {
        this.targetList = new ArrayList();
        this.targetList.add(target);
    }

    public void setTargets(List targets) {
        this.targetList = targets;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String toString() {
        String target;
        StringBuffer buf = new StringBuffer(BonsaiUIStyle.getLaunchUri() + "?");
        buf.append("type=" + this.taskType);
        if (this.taskId != null) {
            buf.append("&task=" + this.taskId);
        }
        if ((target = this.getTargetString()) != null) {
            buf.append("&targets=" + target);
        }
        if (this.parent != null) {
            buf.append("&parent=" + this.parent);
        }
        return buf.toString();
    }

    private String getTargetString() {
        int numTargets = this.targetList.size();
        if (numTargets == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer((String)this.targetList.get(0));
        for (int i = 1; i < numTargets; ++i) {
            buf.append("+" + (String)this.targetList.get(i));
        }
        return buf.toString();
    }

    public Object clone() {
        TaskUrl clone = null;
        try {
            clone = (TaskUrl)super.clone();
        }
        catch (CloneNotSupportedException cnsEx) {
            return null;
        }
        clone.taskId = this.taskId;
        clone.taskType = this.taskType;
        clone.setTargets(this.targetList);
        clone.setParent(this.parent);
        return clone;
    }
}

